<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class ResearchScamV3Restrict extends \Google\Collection
{
  protected $collection_key = 'namespaces';
  protected $namespacesType = ResearchScamTokenNamespace::class;
  protected $namespacesDataType = 'array';

  /**
   * @param ResearchScamTokenNamespace[]
   */
  public function setNamespaces($namespaces)
  {
    $this->namespaces = $namespaces;
  }
  /**
   * @return ResearchScamTokenNamespace[]
   */
  public function getNamespaces()
  {
    return $this->namespaces;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResearchScamV3Restrict::class, 'Google_Service_Contentwarehouse_ResearchScamV3Restrict');
